/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.Server;
import noppes.npcs.api.handler.IMarcetHandler;
import noppes.npcs.api.handler.data.IDeal;
import noppes.npcs.api.handler.data.IMarcet;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.data.Deal;
import noppes.npcs.controllers.data.DealMarkup;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.MarcetSection;

public class MarcetController
implements IMarcetHandler {
    private static MarcetController instance;
    private String filePath;
    public final Map<Integer, Marcet> markets = new TreeMap<Integer, Marcet>();
    public final Map<Integer, Deal> deals = new TreeMap<Integer, Deal>();

    public static MarcetController getInstance() {
        if (MarcetController.newInstance()) {
            instance = new MarcetController();
        }
        return instance;
    }

    private static boolean newInstance() {
        if (instance == null) {
            return true;
        }
        File file = CustomNpcs.getWorldSaveDirectory();
        return file != null && !MarcetController.instance.filePath.equals(file.getAbsolutePath());
    }

    public MarcetController() {
        instance = this;
        this.filePath = CustomNpcs.getWorldSaveDirectory().getAbsolutePath();
        this.load();
    }

    @Override
    public IDeal addDeal() {
        Deal deal = new Deal(this.getUnusedDealId());
        this.deals.put(deal.getId(), deal);
        return deal;
    }

    @Override
    public IMarcet addMarcet() {
        Marcet marcet = new Marcet(this.getUnusedMarketId());
        this.markets.put(marcet.getId(), marcet);
        return this.markets.get(marcet.getId());
    }

    public DealMarkup getBuyData(Marcet marcet, Deal deal, int marcetLevel) {
        DealMarkup dm = new DealMarkup();
        if (deal != null) {
            dm.set(deal);
        }
        if (marcet != null) {
            dm.set(marcet.markup.containsKey(marcetLevel) ? marcet.markup.get(marcetLevel) : (marcetLevel >= marcet.markup.size() ? marcet.markup.get(marcet.markup.size() - 1) : marcet.markup.get(0)));
        }
        return dm;
    }

    @Override
    public IDeal getDeal(int dealId) {
        return this.deals.get(dealId);
    }

    @Override
    public int[] getDealIDs() {
        int[] arr = new int[this.deals.size()];
        int i = 0;
        for (Deal m : this.deals.values()) {
            arr[i] = m.getId();
            ++i;
        }
        return arr;
    }

    @Override
    public IMarcet getMarcet(int marcetId) {
        if (marcetId < 0 || !this.markets.containsKey(marcetId)) {
            return null;
        }
        return this.markets.get(marcetId);
    }

    @Override
    public IMarcet getMarcet(String name) {
        for (Marcet m : this.markets.values()) {
            if (!m.name.equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public int[] getMarketIDs() {
        int[] arr = new int[this.markets.size()];
        int i = 0;
        for (Marcet m : this.markets.values()) {
            arr[i] = m.getId();
            ++i;
        }
        return arr;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList mList = new NBTTagList();
        for (Marcet marcet : this.markets.values()) {
            if (marcet == null) continue;
            NBTTagCompound nbtMarcet = marcet.writeToNBT();
            mList.func_74742_a((NBTBase)nbtMarcet);
        }
        compound.func_74782_a("Marcets", (NBTBase)mList);
        NBTTagList dList = new NBTTagList();
        for (Deal deal : this.deals.values()) {
            if (deal == null) continue;
            NBTTagCompound nbtDeal = deal.writeToNBT();
            dList.func_74742_a((NBTBase)nbtDeal);
        }
        compound.func_74782_a("Deals", (NBTBase)dList);
        int n = 1;
        compound.func_74768_a("Version", n);
        return compound;
    }

    public int getUnusedDealId() {
        int id = 0;
        while (this.deals.containsKey(id)) {
            ++id;
        }
        return id;
    }

    public int getUnusedMarketId() {
        int id = 0;
        while (this.markets.containsKey(id)) {
            ++id;
        }
        return id;
    }

    private void load() {
        CustomNpcs.debugData.start(null);
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        if (saveDir == null || saveDir.toString().equals(".")) {
            CustomNpcs.debugData.end(null);
            return;
        }
        this.filePath = saveDir.getAbsolutePath();
        try {
            File file = new File(saveDir, "marcet.dat");
            if (file.exists()) {
                this.load(file);
            }
        }
        catch (Exception e) {
            try {
                File file2 = new File(saveDir, "marcet.dat_old");
                if (file2.exists()) {
                    this.load(file2);
                }
            }
            catch (Exception er) {
                LogWriter.error(er);
            }
        }
        if (this.markets.isEmpty() || !this.markets.containsKey(0)) {
            this.loadDefaultMarcets();
        }
        CustomNpcs.debugData.end(null);
    }

    private void load(File file) throws IOException {
        this.load(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])));
    }

    public void load(NBTTagCompound nbtFile) throws IOException {
        block14: {
            int v;
            block13: {
                int tab;
                int i;
                this.markets.clear();
                this.deals.clear();
                v = nbtFile.func_74762_e("Version");
                if (v != 0) break block13;
                HashMap marketDeals = new HashMap();
                if (nbtFile.func_150297_b("Deals", 9)) {
                    for (i = 0; i < nbtFile.func_150295_c("Deals", 10).func_74745_c(); ++i) {
                        NBTTagCompound nbtDeal = nbtFile.func_150295_c("Deals", 10).func_150305_b(i);
                        Deal deal = this.loadDeal(nbtDeal);
                        if (deal == null) continue;
                        this.deals.put(deal.getId(), deal);
                        int mId = nbtDeal.func_74762_e("MarcetID");
                        if (!marketDeals.containsKey(mId)) {
                            marketDeals.put(mId, new TreeMap());
                        }
                        tab = nbtDeal.func_74762_e("SectionID");
                        if (!((Map)marketDeals.get(mId)).containsKey(tab)) {
                            ((Map)marketDeals.get(mId)).put(tab, new ArrayList());
                        }
                        Deal d = deal.copy();
                        d.updateNew();
                        ((List)((Map)marketDeals.get(mId)).get(tab)).add(d);
                    }
                }
                if (!nbtFile.func_150297_b("Marcets", 9)) break block14;
                for (i = 0; i < nbtFile.func_150295_c("Marcets", 10).func_74745_c(); ++i) {
                    Marcet marcet = this.loadMarcet(nbtFile.func_150295_c("Marcets", 10).func_150305_b(i));
                    if (marcet == null) continue;
                    this.markets.put(marcet.getId(), marcet);
                    Map sections = (Map)marketDeals.get(marcet.getId());
                    if (sections.isEmpty()) continue;
                    Iterator iterator = sections.keySet().iterator();
                    while (iterator.hasNext()) {
                        tab = (Integer)iterator.next();
                        if (!marcet.sections.containsKey(tab)) {
                            marcet.sections.put(tab, new MarcetSection(tab));
                        }
                        for (Deal d : (List)sections.get(tab)) {
                            marcet.sections.get((Object)Integer.valueOf((int)tab)).deals.add(d);
                        }
                    }
                }
                break block14;
            }
            if (v == 1) {
                int i;
                if (nbtFile.func_150297_b("Deals", 9)) {
                    for (i = 0; i < nbtFile.func_150295_c("Deals", 10).func_74745_c(); ++i) {
                        Deal deal = this.loadDeal(nbtFile.func_150295_c("Deals", 10).func_150305_b(i));
                        if (deal == null) continue;
                        this.deals.put(deal.getId(), deal);
                    }
                }
                if (nbtFile.func_150297_b("Marcets", 9)) {
                    for (i = 0; i < nbtFile.func_150295_c("Marcets", 10).func_74745_c(); ++i) {
                        Marcet marcet = this.loadMarcet(nbtFile.func_150295_c("Marcets", 10).func_150305_b(i));
                        if (marcet == null) continue;
                        this.markets.put(marcet.getId(), marcet);
                    }
                }
            }
        }
    }

    public Deal loadDeal(NBTTagCompound nbtDeal) {
        if (nbtDeal == null || !nbtDeal.func_150297_b("DealID", 3) || nbtDeal.func_74762_e("DealID") < 0) {
            return null;
        }
        int id = nbtDeal.func_74762_e("DealID");
        if (this.deals.containsKey(id)) {
            this.deals.get(id).readFromNBT(nbtDeal);
            for (Marcet market : this.markets.values()) {
                if (market.getDeal(id) == null) continue;
                market.getDeal(id).readFromNBT(nbtDeal);
                market.updateNew();
            }
            return this.deals.get(id);
        }
        Deal deal = new Deal(id);
        deal.readFromNBT(nbtDeal);
        this.deals.put(deal.getId(), deal);
        return deal;
    }

    public void loadDefaultMarcets() {
        Marcet marcet = this.markets.containsKey(0) ? this.markets.get(0) : new Marcet(0);
        marcet.name = "Default Marcet";
        marcet.updateTime = 5;
        marcet.lastTime = System.currentTimeMillis();
        MarcetSection s0 = new MarcetSection(0);
        marcet.sections.clear();
        this.markets.put(marcet.getId(), marcet);
        Deal d0 = this.deals.containsKey(0) ? this.deals.get(0) : (Deal)this.addDeal();
        d0.set(new ItemStack(Items.field_151045_i), new ItemStack[]{new ItemStack(Items.field_151043_k, 10, 0), new ItemStack(Items.field_151042_j, 45, 0)});
        d0.setType(2);
        d0.setCount(2, 7);
        d0.setChance(0.1575f);
        s0.addDeal(0);
        Deal d1 = this.deals.containsKey(1) ? this.deals.get(1) : (Deal)this.addDeal();
        d1.set(new ItemStack(Items.field_151042_j, 4, 0), new ItemStack[]{new ItemStack(Items.field_151043_k)});
        d1.setType(2);
        d1.setChance(0.8f);
        s0.addDeal(1);
        marcet.sections.put(s0.getId(), s0);
        MarcetSection s1 = new MarcetSection(1);
        s1.name = "market.default.section.1";
        Deal d2 = this.deals.containsKey(2) ? this.deals.get(2) : (Deal)this.addDeal();
        d2.set(new ItemStack(Blocks.field_150347_e, 16, 0), new ItemStack[0]);
        d2.setType(1);
        d2.setMoney(160);
        d2.setChance(0.955f);
        s1.addDeal(2);
        marcet.sections.put(s1.getId(), s1);
        this.saveMarcets();
    }

    public Marcet loadMarcet(NBTTagCompound nbtMarcet) {
        if (nbtMarcet == null || !nbtMarcet.func_150297_b("MarcetID", 3) || nbtMarcet.func_74762_e("MarcetID") < 0) {
            return null;
        }
        int id = nbtMarcet.func_74762_e("MarcetID");
        Marcet marcet = this.markets.containsKey(id) ? this.markets.get(id) : new Marcet(id);
        marcet.readFromNBT(nbtMarcet);
        this.markets.put(marcet.getId(), marcet);
        return this.markets.get(marcet.getId());
    }

    public int loadOld(NBTTagCompound nbttagcompound) {
        String marketName = nbttagcompound.func_74779_i("TraderMarket");
        if (!marketName.isEmpty()) {
            for (Marcet m : this.markets.values()) {
                if (!m.name.equalsIgnoreCase(marketName)) continue;
                return m.getId();
            }
        }
        Marcet marcet = (Marcet)this.addMarcet();
        if (!marketName.isEmpty()) {
            marcet.setName(marketName);
        }
        boolean ignoreDamage = nbttagcompound.func_74767_n("TraderIgnoreDamage");
        boolean ignoreNBT = nbttagcompound.func_74767_n("TraderIgnoreNBT");
        NpcMiscInventory inventoryCurrency = new NpcMiscInventory(36);
        NpcMiscInventory inventorySold = new NpcMiscInventory(18);
        inventoryCurrency.load(nbttagcompound.func_74775_l("TraderCurrency"));
        inventorySold.load(nbttagcompound.func_74775_l("TraderSold"));
        for (int i = 0; i < 18; ++i) {
            if (inventorySold.func_70301_a(i).func_190926_b()) continue;
            ItemStack st0 = inventoryCurrency.func_70301_a(i);
            ItemStack st1 = inventoryCurrency.func_70301_a(i + 18);
            if (st0.func_190926_b() && st1.func_190926_b()) continue;
            Deal deal = (Deal)this.addDeal();
            deal.set(inventorySold.func_70301_a(i), new ItemStack[]{st0, st1});
            deal.setIgnoreDamage(ignoreDamage);
            deal.setIgnoreNBT(ignoreNBT);
            marcet.sections.get(0).addDeal(deal.getId());
        }
        return marcet.getId();
    }

    @Override
    public void removeDeal(int dealID) {
        if (this.deals.containsKey(dealID)) {
            this.deals.remove(dealID);
            for (Marcet m : this.markets.values()) {
                block1: for (MarcetSection ms : m.sections.values()) {
                    for (Deal deal : ms.deals) {
                        if (deal.getId() != dealID) continue;
                        ms.deals.remove(deal);
                        continue block1;
                    }
                }
            }
        }
        this.saveMarcets();
    }

    @Override
    public void removeMarcet(int marcetID) {
        if (marcetID < 0 || marcetID != 0 && this.markets.size() <= 1) {
            return;
        }
        if (!this.markets.containsKey(marcetID)) {
            if (marcetID == 0) {
                this.loadDefaultMarcets();
            }
            return;
        }
        Marcet marcet = this.markets.get(marcetID);
        marcet.closeForAllPlayers();
        this.markets.remove(marcetID);
        if (marcetID == 0) {
            this.loadDefaultMarcets();
        }
        this.saveMarcets();
    }

    public void saveMarcets() {
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            if (saveDir == null || saveDir.toString().equals(".")) {
                return;
            }
            File file = new File(saveDir, "marcet.dat_new");
            File file2 = new File(saveDir, "marcet.dat_old");
            File file3 = new File(saveDir, "marcet.dat");
            NBTTagCompound nbtFile = this.getNBT();
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbtFile, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void sendTo(EntityPlayerMP player, int marcetID) {
        LogWriter.debug("CustomNpcs: Send marked data to \"" + player.func_70005_c_() + "\"; marcetID: " + marcetID);
        if (this.markets.containsKey(marcetID)) {
            this.markets.get(marcetID).sendTo(player);
            Server.sendDataDelayed(player, EnumPacketClient.MARCET_DATA, 250, 2);
        } else if (marcetID < 0) {
            int id;
            if (this.markets.isEmpty() || !this.markets.containsKey(0)) {
                this.loadDefaultMarcets();
            }
            HashMap<Integer, Marcet> mapM = new HashMap<Integer, Marcet>(this.markets);
            HashMap<Integer, Deal> mapD = new HashMap<Integer, Deal>(this.deals);
            Server.sendData(player, EnumPacketClient.MARCET_DATA, 0);
            Iterator iterator = mapD.keySet().iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 3, ((Deal)mapD.get(id)).writeToNBT());
            }
            iterator = mapM.keySet().iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                Server.sendData(player, EnumPacketClient.MARCET_DATA, 1, ((Marcet)mapM.get(id)).writeToNBT());
            }
            Server.sendDataDelayed(player, EnumPacketClient.MARCET_DATA, 250, 2);
        } else {
            Server.sendData(player, EnumPacketClient.MARCET_DATA, 4, marcetID);
        }
    }

    public void update() {
        try {
            for (Marcet m : new ArrayList<Marcet>(this.markets.values())) {
                m.update();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (Deal d : new ArrayList<Deal>(this.deals.values())) {
                d.update();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateTime() {
        try {
            for (Marcet m : new ArrayList<Marcet>(this.markets.values())) {
                m.updateTime();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

